package com.bitbof.escape.entities;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.imageio.ImageIO;

import org.lwjgl.examples.spaceinvaders.Texture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

import com.bitbof.escape.Art;

public class World{
	
	public static final String LEVEL_FILE = "level.png";	
	public static final float LEVEL_SCALE = 50;	
	
	public double timeFactor = 0.1f;
	
	public List<Entity> entities;
	public List<Hook> hooks;
	public Player player;
	public Camera camera = new Camera();
	
	public List<Entity> addQueue;
	private long tick = 0;
	public Popup pop;
	
	public World() {
		entities = new ArrayList<Entity>();
		addQueue = new ArrayList<Entity>();
		
		hooks = new ArrayList<Hook>();
		pop = new Popup(this);
		entities.add(pop);
		
		//entities.add(new Blob(this, null, 0, 0, 1900));
		player = new Player(this);
		loadLevel();
		camera.pos = new Vector2f(player.pos);
		camera.lastPos = new Vector2f(player.pos);
		
	}
	
	public void loadLevel() {
		
		Image img = null;
		try {
		 	//img = ImageIO.read(is);
			img = ImageIO.read(new File("level.png"));
			
		} catch (Exception e1) {
			System.out.println("ex "+ e1.getMessage());
			e1.printStackTrace();
		}
		if(img == null)
			return;
		BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), BufferedImage.TYPE_INT_ARGB);
        Graphics g = bufferedImage.getGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        int w = bufferedImage.getWidth(null);
        int h = bufferedImage.getHeight(null);
        int[] rgb = new int[w*h];
        bufferedImage.getRGB(0, 0, w, h, rgb, 0, w);
        for(int i = 0; i < w; i++) {
        	for(int e = 0; e < h; e++) {
        		int col = rgb[i+e*w] & 0xFFFFFF;
        		if(col == 0x0000FF) {
        			player.pos.x = i*LEVEL_SCALE;
        			player.pos.y = -e*LEVEL_SCALE;
        			player.band.pos.x = player.pos.x;
        			player.band.pos.y = player.pos.y;
        			System.out.println("found");
        		} else if(col == 0x00FF00) {
        			ElasticHook hook = new ElasticHook();
        			hook.world = this;
        			hook.pos.x = i*LEVEL_SCALE;
        			hook.pos.y = -e*LEVEL_SCALE;
        			hooks.add(hook);
        		} else if(col == 0x32a000) {
        			ElasticHook hook = new ElasticHook();
        			hook.world = this;
        			hook.MAX_HEALTH *= 5;
        			hook.radius *= 4;
        			hook.pos.x = i*LEVEL_SCALE;
        			hook.pos.y = -e*LEVEL_SCALE;
        			hooks.add(hook);
        		}else if(col == 0x006009) {
        			ElasticHook hook = new ElasticHook();
        			hook.world = this;
        			hook.MAX_HEALTH *= 50;
        			hook.radius *= 8;
        			hook.pos.x = i*LEVEL_SCALE;
        			hook.pos.y = -e*LEVEL_SCALE;
        			hooks.add(hook);
        		} else if(col == 0x7cff62) {
        			ElasticHook hook = new ElasticHook();
        			hook.world = this;
        			hook.MAX_HEALTH /= 6;
        			hook.radius /= 2;
        			hook.pos.x = i*LEVEL_SCALE;
        			hook.pos.y = -e*LEVEL_SCALE;
        			hooks.add(hook);
        		} else if(col == 0x00b971) {
        			GravityElasticHook hook = new GravityElasticHook();
        			hook.world = this;
        			hook.startpos.x = i*LEVEL_SCALE;
        			hook.startpos.y = -e*LEVEL_SCALE;
        			hook.pos = new Vector2f(hook.startpos);
        			hooks.add(hook);
        		} else if(col == 0xe0a900) {
        			MovingElasticHook hook = new MovingElasticHook();
        			hook.world = this;
        			hook.startX = i*LEVEL_SCALE;
        			hook.pos.x = i*LEVEL_SCALE;
        			hook.pos.y = -e*LEVEL_SCALE;
        			hook.phase = 0;
        			hooks.add(hook);
        		}  else if(col == 0xe06400) {
        			MovingElasticHook hook = new MovingElasticHook();
        			hook.world = this;
        			hook.startX = i*LEVEL_SCALE;
        			hook.pos.x = i*LEVEL_SCALE;
        			hook.pos.y = -e*LEVEL_SCALE;
        			hook.phase = 1;
        			hooks.add(hook);
        		}  else if(col == 0x00ffff) {
        			entities.add( new Cutter(this,i*LEVEL_SCALE, -e*LEVEL_SCALE));
	 
        		}
        	}
        }
	}
	
	public void tick() {
		entities.addAll(addQueue);
		addQueue.clear();
		for(int i = 0; i < entities.size(); i++) {
			Entity e = entities.get(i);
			e.tick();
			if(!e.isAlive()){
				entities.remove(i--);
			}
		}
		for(Hook h: hooks){
			h.tick();
		}
		player.tick();
		if(!player.alive)
			player = null;
		tick++;
		camera.update(player.pos.x, player.pos.y);
		
	}
	public void render() {
		renderOrientation();
		//entities
		

		if(player.band != null)
			player.band.render();
		for(Hook eh: hooks) {
			eh.render();
		}
		player.render();
		
	}
	public void renderEnts() {
		
		if(tick < 500) {
			Art.bg01.bind();
			GL11.glPushMatrix();
			GL11.glTranslated(player.pos.x,player.pos.y,0);
	
			GL11.glColor4f(0, 0, 0, (500-tick)/500f);
	
			Texture texture = Art.blob;
			// rotate square according to angle
			GL11.glRotatef(0, 0, 0, 1);
			GL11.glScalef(8000, 8000, 0);
			GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
	
			GL11.glPopMatrix();
		}
		
		for(Entity e: entities) {
			e.render();
		}
	}
	
	public void add(Entity e) {
		addQueue.add(e);
	}
	
	public void renderOrientation() {
		Art.orientation.bind();
		GL11.glPushMatrix();
		GL11.glTranslated(LEVEL_SCALE*256, -LEVEL_SCALE*256, 0);

		GL11.glColor4f(1, 1, 1, 1);

		Texture texture = Art.orientation;
		// rotate square according to angle
		GL11.glRotatef(-90, 0, 0, 1);
		GL11.glScalef(LEVEL_SCALE*512, LEVEL_SCALE*512, 0);
		GL11.glBegin(GL11.GL_QUADS);
			GL11.glTexCoord2f(0, 0);
			GL11.glVertex2f(-0.5f, -0.5f);
			GL11.glTexCoord2f(0, texture.getHeight());
			GL11.glVertex2f(0.5f, -0.5f);
			GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
			GL11.glVertex2f(0.5f, 0.5f);
			GL11.glTexCoord2f(texture.getWidth(), 0);
			GL11.glVertex2f(-0.5f, 0.5f);
		GL11.glEnd();

		GL11.glPopMatrix();
	}
	
	public void renderBackground()  {
		{
			Art.bg01.bind();
			GL11.glPushMatrix();
			GL11.glTranslated(Math.sin(tick/100f+0.3*timeFactor)*1000+Math.cos(tick/140f+0.1)*1000, Math.sin(tick/80f+0.5)*1000+Math.cos(-tick/120f+0.4)*1000, 0);
	
			GL11.glColor4f(1, 1, 1, 0.5f);
	
			Texture texture = Art.blob;
			// rotate square according to angle
			GL11.glRotatef(0, 0, 0, 1);
			GL11.glScalef(8000, 8000, 0);
			GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
	
			GL11.glPopMatrix();
		}
		{
			GL11.glPushMatrix();
			GL11.glTranslated(Math.sin(-tick/300f+0.3)*2000+Math.cos(tick/130f+0.1)*400, Math.sin(-tick/80f+0.5)*1000+Math.cos(-tick/1200f+0.4)*2000, 0);
	
			GL11.glColor4f(1, 1, 1, 0.5f);
	
			Texture texture = Art.blob;
			// rotate square according to angle
			GL11.glRotatef(1, 0, 0, (float) (Math.sin(-tick/300f+0.3)*2000+Math.cos(tick/130f+0.1)*400));
			GL11.glScalef(8000, 8000, 0);
			GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
	
			GL11.glPopMatrix();
		}
	}
}
